<?php

// Utility code used to build a vbadvanced module
// At minimum, this needs a wrap-around as follows:
//
// 		$vba_module = create_vba_module("Module Title", "Module Identifier", "phpFile");
// 		save_vba_module($vba_module, "Module filename");
//
//
// Between the calls to create and to save, there can be one or more calls to add_vba_setting() to define
// parameters which can be set by the admin:
//
// 		add_vba_setting($vba_module, "varname", "grouptitle", "title", "description" [, "optioncode"] [, "value"] [, "defaultvalue"]);
//

/**
* Create vba module definition
*
* @param	str		Module title
* @param	str		vba module identifier
* @param	str		.php file containing module's code
* @param	str		.xml file containing module's templates
* @param	str		If set, a list of templates other than those in .xml file which should be pre-loaded when using module
* @param	str		="1" (default) - module should use the adv_portal_module_wrapper template, ="0", not wrapped
* @param	int		if set, use as colspan for module's title row
* @return	array	Module object
*/

function create_vba_module($title, $identifier, $file, $templates="", $othertemplates="", $useshell="1", $colspan="0") {

	$vba_module = array();
	$vba_module["templates"] = array();
	$templatelist = array();

	if ($templates) {
		$fp = @fopen($templates, "r");
		if (!$fp) {
			echo "Unable to open template file '".$templates."'";
			die();
		}
		$xml = fread($fp, 10240000);
		if (!$xml) {
			echo "Unable to read template file '".$templates."'";
			die();
		}
		fclose($fp);
		$xmlobj = new XMLparser($xml);
		if ($xmlobj->error_no == 1 or $xmlobj->error_no == 2) {
			echo "Unable to create xml parser for '".$templates."'";
			die();
		}
		if (!$arr =& $xmlobj->parse()) {
			echo "Unable to parse template file '".$templates."'";
			die();
		}
		if (isset($arr["template"][0])) {
			foreach ($arr["template"] as $thisarr) {
				$vba_module["templates"][$thisarr["name"]] = $thisarr["value"];
				$templatelist[] = $thisarr["name"];
			}
		}
		else {
			$vba_module["templates"][$arr["template"]["name"]] = $arr["template"]["value"];
			$templatelist[] = $arr["template"]["name"];
		}
	}

	if ($othertemplates) {
		$templatelist = array_merge($templatelist, explode(",", preg_replace("/\s/", "", $othertemplates)));
	}

	$templatelist = implode("\r\n", $templatelist);
	$vba_module["templates"] = serialize($vba_module["templates"]);

	$vba_module["module"] = array(
		"title" => $title,
		"identifier" => $identifier,
		"inctype" => "php_file",
		"parent" => "",
		"templatelist" => $templatelist,
		"colspan" => "$colspan",
		"formcode" => "",
		"cleanoutput" => "0",
		"options" => "",
		"useshell" => "$useshell",
		"link" => "",
	);

	$fp = @fopen($file, "r");
	if (!$fp) {
		echo "Unable to open template file '".$templates."'";
		die();
	}
	$vba_module["file"] = fread($fp, 1024000);
	fclose($fp);

	$vba_module["module"]["filename"] = $identifier.".php";
//	$vba_module["module"] = serialize($vba_module["module"]);

	return $vba_module;
}

/**
* Updates vba module definition to include a parameter which can be set by admin
*
* @param	array	Module object created by create_vba_module()
* @param	str		parameter id
* @param	str		parameter group id (shold be same for all settings of module
* @param	str		textual name for parameter
* @param	str		textual description for parameter
* @param	str		parameter type: 
* 					'' (default) textbox, 'textarea', 'yesno' radio button, 'forumselect' menu, 'calendarselect' menu, 'threadselect' menu
* @param	str		current value of the setting (normally leave blank)
* @param	str		default value of the setting (default - blank)
* @return	array	Module object
*/

function add_vba_setting(&$vba_module, $varname, $grouptitle, $title, $description, $optioncode="", $value="", $defaultvalue="") {
	global $option_codes;

	if (!isset($vba_module["settings"])) {
		$vba_module["settings"] = array();
		$displayorder = 1;
	}
	else {
		foreach ($vba_module["settings"] as $setting) {
			$displayorder = $setting["displayorder"] + 1;
		}
	}

	$vba_module["settings"][$varname] = array(
		"varname" => "$varname",
		"grouptitle" => "$grouptitle",
		"value" => "$value",
		"defaultvalue" => "$defaultvalue",
		"optioncode" => "$optioncode",
		"displayorder" => "$displayorder",
		"serialize" => ($optioncode=="forumselect" || $optioncode=="threadselect" ? "1" : "0" ),
		"title" => "$title",
		"description" => "$description",
	);

}

/**
* Save vba module to file
*
* @param	array	Module object created by create_vba_module()
* @param	str		vba module file
*/

function save_vba_module($moduleinfo, $file) {
	$vba_module = serialize($moduleinfo);
	$fp = @fopen($file, "w");
	if (!$fp) {
		echo "Unable to open module file '".$file."'";
		die();
	}
	fwrite($fp, $vba_module);
	fclose($fp);
}

/**
* Save vba module as xml file
*
* @param	array	Module object created by create_vba_module()
* @param	str		vba module xml file
*/

function sort_xml_array(&$xml, $name, $data) {
	if (is_array($data)) {
		$xml->add_group($name, '');
		foreach ($data AS $name2 => $data2) {
			sort_xml_array($xml, $name2, $data2);
		}
		$xml->close_group();
	}
	else {
		$xml->add_tag($name, $data);
	}
}

function save_vba_xml($moduleinfo, $file) {

	$moduleinfo["templates"] = unserialize($moduleinfo["templates"]);

	require_once('./vbautil/class_xml.php');
	$xml = new vB_XML_Builder();

	$xml->add_group('moduleinfo', '');

	sort_xml_array($xml, "module", $moduleinfo["module"]);
	sort_xml_array($xml, "templates", $moduleinfo["templates"]);
	sort_xml_array($xml, "file", $moduleinfo["file"]);
	sort_xml_array($xml, "settings", $moduleinfo["settings"]);

	$xml->close_group();

	$moduleinfo = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\r\n";
	$moduleinfo .= $xml->output();

	$filename .= '.xml';
	$content_type = 'text/xml';

	$fp = @fopen($file, "w");
	if (!$fp) {
		echo "Unable to create xml file '".$file."'";
		die();
	}
	fwrite($fp, $moduleinfo);
	fclose($fp);
}

?>



